<?php
/**
 * Plugin Name: WP Markdown Cleaner
 * Plugin URI: https://www.wuyouseo.com/
 * Description: 一键清除文章编辑器中的 Markdown 格式，支持古腾堡编辑器和经典编辑器。
 * Version: 2.0.1
 * Author: 无忧AI
 * Author URI: https://www.wuyouseo.com/
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wp-markdown-cleaner
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.4
 */

// 如果直接访问此文件，则退出
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 定义插件常量
define( 'WP_MD_CLEANER_VERSION', '2.0.1' );
define( 'WP_MD_CLEANER_PLUGIN_FILE', __FILE__ );
define( 'WP_MD_CLEANER_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WP_MD_CLEANER_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'WP_MD_CLEANER_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * 自动加载类文件
 */
function wp_md_cleaner_autoloader( $class ) {
    // 只加载本插件的类
    if ( strpos( $class, 'WP_MD_Cleaner_' ) !== 0 ) {
        return;
    }

    // 转换类名为文件名
    $class_file = 'class-' . strtolower( str_replace( '_', '-', str_replace( 'WP_MD_Cleaner_', '', $class ) ) ) . '.php';
    
    // 在 includes 和 admin 目录中查找
    $paths = array(
        WP_MD_CLEANER_PLUGIN_DIR . 'includes/',
        WP_MD_CLEANER_PLUGIN_DIR . 'admin/',
    );

    foreach ( $paths as $path ) {
        $file = $path . $class_file;
        if ( file_exists( $file ) ) {
            require_once $file;
            return;
        }
    }
}
spl_autoload_register( 'wp_md_cleaner_autoloader' );

/**
 * 插件激活钩子
 */
function wp_md_cleaner_activate() {
    // 设置默认选项
    $default_options = array(
        'headings'        => true,
        'bold'            => true,
        'italic'          => true,
        'strikethrough'   => true,
        'links'           => true,
        'images'          => true,
        'code_inline'     => true,
        'code_block'      => true,
        'blockquote'      => true,
        'list_unordered'  => true,
        'list_ordered'    => true,
        'horizontal_rule' => true,
        'table'           => true,
    );

    if ( ! get_option( 'wp_md_cleaner_rules' ) ) {
        add_option( 'wp_md_cleaner_rules', $default_options );
    }
}
register_activation_hook( __FILE__, 'wp_md_cleaner_activate' );

/**
 * 插件停用钩子
 */
function wp_md_cleaner_deactivate() {
    // 停用时不删除选项，保留用户设置
}
register_deactivation_hook( __FILE__, 'wp_md_cleaner_deactivate' );

/**
 * 加载文本域（多语言支持）
 */
function wp_md_cleaner_load_textdomain() {
    load_plugin_textdomain(
        'wp-markdown-cleaner',
        false,
        dirname( WP_MD_CLEANER_PLUGIN_BASENAME ) . '/languages'
    );
}
add_action( 'plugins_loaded', 'wp_md_cleaner_load_textdomain' );

/**
 * 初始化插件
 */
function wp_md_cleaner_init() {
    // 初始化核心类
    if ( class_exists( 'WP_MD_Cleaner_Core' ) ) {
        WP_MD_Cleaner_Core::instance();
    }
}
add_action( 'plugins_loaded', 'wp_md_cleaner_init' );
