<?php
/**
 * 卸载脚本
 * 
 * 当插件被删除时执行
 *
 * @package WP_Markdown_Cleaner
 */

// 如果不是通过 WordPress 卸载，则退出
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// 删除插件选项
delete_option( 'wp_md_cleaner_rules' );

// 对于多站点，删除所有站点的选项
if ( is_multisite() ) {
    global $wpdb;
    $blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
    
    foreach ( $blog_ids as $blog_id ) {
        switch_to_blog( $blog_id );
        delete_option( 'wp_md_cleaner_rules' );
        restore_current_blog();
    }
}
