/**
 * Markdown 导入脚本
 */
(function ($) {
    'use strict';

    $(document).ready(function () {
        var $modal = $('#wp-md-import-modal');
        var $btn = $('#wp-md-import-btn');
        var $closeBtn = $('.wp-md-modal-close');
        var $overlay = $('.wp-md-modal-overlay');
        var $processBtn = $('#wp-md-process-import');
        var $textarea = $('#wp-md-input-area');

        if ($btn.length === 0) {
            return;
        }

        // 打开弹窗
        $btn.on('click', function (e) {
            e.preventDefault();
            $modal.fadeIn(200);
            $textarea.focus();
        });

        // 关闭弹窗
        function closeModal() {
            $modal.fadeOut(200);
        }

        $closeBtn.on('click', closeModal);
        $overlay.on('click', closeModal);

        // 处理 ESC 键关闭
        $(document).on('keydown', function (e) {
            if (e.keyCode === 27 && $modal.is(':visible')) {
                closeModal();
            }
        });

        // 提交处理
        $processBtn.on('click', function () {
            var content = $textarea.val();

            if (!content || content.trim() === '') {
                alert(wpMdImportData.i18n.no_content);
                return;
            }

            // 禁用按钮显示加载状态
            var originalText = $processBtn.html();
            $processBtn.prop('disabled', true).text(wpMdImportData.i18n.processing);

            $.ajax({
                url: wpMdImportData.ajax_url,
                type: 'POST',
                data: {
                    action: 'wp_md_cleaner_import',
                    nonce: wpMdImportData.nonce,
                    content: content
                },
                success: function (response) {
                    $processBtn.prop('disabled', false).html(originalText);

                    if (response.success && response.data && response.data.html !== undefined) {
                        // 插入内容到编辑器
                        insertContent(response.data.html);

                        // 清空输入框并关闭弹窗
                        $textarea.val('');
                        closeModal();

                        // 显示成功提示（可选）
                        // alert(wpMdImportData.i18n.success);
                    } else {
                        alert(response.data && response.data.message ? response.data.message : wpMdImportData.i18n.error);
                    }
                },
                error: function () {
                    $processBtn.prop('disabled', false).html(originalText);
                    alert(wpMdImportData.i18n.error);
                }
            });
        });

        /**
         * 插入内容到活动编辑器
         */
        function insertContent(html) {
            if (typeof tinymce !== 'undefined' && tinymce.activeEditor && !tinymce.activeEditor.isHidden()) {
                tinymce.activeEditor.insertContent(html);
            } else if (typeof wp !== 'undefined' && wp.editor && wp.editor.insert) {
                // 古腾堡或兼容模式
                wp.editor.insert(html);
            } else {
                // 文本编辑器回退
                var currentContent = $('#content').val();
                $('#content').val(currentContent + "\n" + html);
            }
        }
    });

})(jQuery);
