# WP Markdown Cleaner (Markdown 导入器)

一款 WordPress 插件，用于将 Markdown 格式内容一键转换为 HTML 并导入到编辑器中。

## 功能特性

- ✅ **Markdown 导入弹窗**：提供专属的 Markdown 源码输入窗口
- ✅ **自动格式转换**：自动解析 Markdown 并转换为标准 HTML 标签
- ✅ **双编辑器支持**：完美兼容古腾堡编辑器（Block Editor）和经典编辑器（Classic Editor）
- ✅ **原生视觉体验**：采用 WordPress 原生媒体库风格的沉浸式 UI
- ✅ **智能插入**：转换后的内容直接插入光标位置

## 支持的 Markdown 格式

插件内置强大的解析器，支持以下标准 Markdown 语法：

| 格式 | Markdown 语法 | 转换后 HTML |
|------|---------------|-------------|
| 标题 | `# 标题` | `<h1>标题</h1>` |
| 粗体 | `**文字**` | `<strong>文字</strong>` |
| 斜体 | `*文字*` | `<em>文字</em>` |
| 删除线 | `~~文字~~` | `<del>文字</del>` |
| 链接 | `[文字](url)` | `<a href="url">文字</a>` |
| 图片 | `![描述](url)` | `<img src="url" alt="描述">` |
| 代码块 | ` ```代码``` ` | `<pre><code>代码</code></pre>` |
| 引用 | `> 引用` | `<blockquote>引用</blockquote>` |
| 无序列表 | `- 项目` | `<ul><li>项目</li></ul>` |
| 有序列表 | `1. 项目` | `<ol><li>项目</li></ol>` |
| 分隔线 | `---` | `<hr />` |

## 安装方法

### 方法一：WordPress 后台安装

1. 前往 **插件 → 安装插件**
2. 搜索 "WP Markdown Cleaner"
3. 点击 **现在安装**，然后 **激活**

### 方法二：手动上传

1. 下载插件 ZIP 文件
2. 前往 **插件 → 安装插件 → 上传插件**
3. 选择 ZIP 文件并上传
4. 激活插件

## 使用说明

1. 打开文章编辑页面（古腾堡或经典编辑器均可）
2. 点击 **"添加媒体"** 按钮旁边的 **"导入Markdown"** 按钮
3. 在弹出的窗口中粘贴您的 Markdown 源码
4. 点击右下角的 **"转换并插入"** 按钮
5. 内容将自动转换为富文本格式并插入到编辑器中

## 目录结构

```
wp-markdown-cleaner/
├── wp-markdown-cleaner.php         # 主插件文件
├── includes/
│   ├── class-core.php              # 核心逻辑与钩子
│   └── class-parser.php            # Markdown 解析器
├── admin/
│   └── assets/
│       ├── js/
│       │   └── import.js           # 导入与弹窗逻辑
│       └── css/
│           └── admin.css           # 面板样式
├── languages/                      # 多语言文件
├── readme.txt                      # WordPress 插件库说明
├── README.md                       # 开发文档（本文件）
└── uninstall.php                   # 卸载脚本
```

## 技术要求

- **WordPress**: 5.0+
- **PHP**: 7.4+

## 开发说明

### 核心变更 (2.0.0+)

插件已从“清除器”重构为“导入器”。核心类 `WP_MD_Cleaner_Parser` 负责将 Markdown 文本解析为 HTML 字符串，完全绕过了编辑器自带的 DOM 处理，从而避免了格式错乱问题。

- **前端交互**：使用原生 JavaScript + jQuery 实现，模仿 WordPress 媒体库 UI。
- **解析逻辑**：后端 PHP 正则匹配与替换，确保输出干净、标准的 HTML。

## 常见问题

**Q: 为什么不仅仅是在编辑器里直接写 Markdown？**  
A: WordPress 编辑器对 Markdown 的支持有限，且粘贴时常会丢失格式或产生错误的 HTML 结构。通过本插件的“导入”模式，可以确保 Markdown 源码被精准转换为 HTML 标签。

**Q: 支持表格吗？**  
A: 目前版本暂不支持 Markdown 表格语法，建议使用编辑器自带的表格块。

## 更新日志

### 2.0.1 (2026-01-14)
- 优化：增大导入弹窗尺寸（800px宽）
- 修复：解决弹窗无法垂直居中问题
- 界面：重绘为 WordPress 原生风格

### 2.0.0 (2026-01-14)
- 重构：从清除器变更为 Markdown 导入器
- 新增：Markdown 解析核心
- 新增：导入弹窗界面

## 许可证

GPL v2 or later

## 作者

无忧AI  
网站: https://www.wuyouseo.com/
