# WP Markdown 导入器 (WP Markdown Cleaner) - 用户指南 & 产品介绍

## 💡 产品简介

**WP Markdown 导入器** 是专为 WordPress 内容创作者打造的高效工具。它完美解决了将 Markdown 格式内容发布到 WordPress 时的格式错乱、样式丢失等痛点。无需繁琐的第三方工具转换，只需一键粘贴，即可在 WordPress 编辑器中生成完美排版的文章。

---

## 🚀 为什么选择它？

如果您习惯使用 Notion、Obsidian、Typora 或 VS Code 等 Markdown 编辑器写作，发布到 WordPress 通常是一场噩梦：
*   ❌ 直接粘贴会导致代码块丢失格式
*   ❌ 标题和列表层级混乱
*   ❌ 图片和链接无法正确解析
*   ❌ 需要手动调整大量 HTML 标签

**WP Markdown 导入器** 让这一切成为历史。它就像一个智能翻译官，将标准的 Markdown 源码精准翻译为 WordPress 原生支持的富文本格式。

---

## ✨ 核心功能

### 1. 沉浸式导入体验
*   提供一个干净、宽敞的专用输入窗口（800px 宽度）。
*   采用 WordPress 原生 UI 设计，与系统完美融合，无割裂感。
*   支持等宽字体输入，代码对齐更舒适。

### 2. 智能格式引擎
内置强大的 Markdown 解析核心，支持：
*   **基础格式**：标题 (H1-H6)、粗体、斜体、删除线
*   **排版元素**：引用块、无序列表、有序列表、水平分割线
*   **富媒体**：超链接自动转换、图片自动识别
*   **代码支持**：支持行内代码和多行代码块

### 3. 双编辑器完美兼容
无论您是 **古腾堡（Gutenberg）** 的拥趸，还是 **经典编辑器（Classic Editor）** 的怀旧派，本插件都能无缝运行：
*   **经典编辑器**：在工具栏媒体按钮旁一键调用。
*   **古腾堡**：在文章工具栏顶部也可以轻松找到入口。

---

## 📖 使用教程

### 第一步：准备 Markdown 内容
从您喜欢的编辑器（如 Typora、Obsidian）中复制 Markdown **源码**。

### 第二步：打开导入窗口
进入 WordPress 写文章页面，点击 **"添加媒体"** 按钮旁边的 **"导入Markdown"** 按钮。

### 第三步：转换并插入
1. 在弹出的窗口中粘贴您的源码。
2. 确认内容无误后，点击右下角的 **"转换并插入"**。
3. 见证奇迹：格式完美的文章已出现在您的编辑器中！

---

## ❓ 常见问题 (FAQ)

**Q: 这个插件会修改我已发布的文章吗？**
A: 绝对不会。插件仅在您编辑文章并主动导入时工作，对现有数据库和已发布内容零干扰。

**Q: 导入后的内容还能修改吗？**
A: 当然可以。转换后的内容就是普通的 WordPress 文章内容，您可以随意编辑、添加图片或调整样式。

**Q: 支持 Markdown 表格吗？**
A: 为保证最佳兼容性，当前版本暂未支持复杂表格。建议导入后使用 WordPress 自带的表格工具创建。

**Q: 插件收费吗？**
A: 完全免费，开源发布。

---

## 🛠 技术规格

*   **版本**：2.0.1
*   **环境要求**：WordPress 5.0+, PHP 7.4+
*   **无需设置**：即装即用，没有繁琐的配置面板。

---

> **高效写作，从 WP Markdown 导入器开始。**
